//
//  CRPathProcessor.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/8/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRPathHolder.h"
#import "CRImageProcessor.h"

//////////////////////////////////////////////////////////////////////
// CRPathProcessor
//////////////////////////////////////////////////////////////////////
@interface CRPathProcessor : CRImageProcessor
{	
	NSBitmapImageRep*	buffer;
	CRPathHolder*		pathHolder;
}

@property (nonatomic, strong) CRPathHolder* pathHolder;	// path

- (NSAffineTransform *)areaTransformForRect:(NSRect)rect;
- (NSBitmapImageRep *)prepareBuffer:(NSBitmapImageRep *)aBuffer forRect:(NSRect)rect;
- (void)prepareRenderWithBuffer:(NSBitmapImageRep *)aBuffer;
- (CIImage *)finalizeRenderForBuffer:(NSBitmapImageRep *)aBuffer;
- (void)renderInRect:(NSRect)rect withTransform:(NSAffineTransform *)transform;

@end